/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Room {
    public Game game;
    public int roomID;
    public Map<String, Player> players;
    public Map<String, Table> tables;
    private List<String> removedPlayerUIDs;
    private Set<Table> tablesWithRemovedPlayers;

    public Room(Game game, int roomID) {
        this.game = game;
        this.roomID = roomID;
        this.players = new HashMap<String, Player>();
        this.tables = new HashMap<String, Table>();
        this.removedPlayerUIDs = new ArrayList<String>();
        this.tablesWithRemovedPlayers = new HashSet<Table>();
    }

    public boolean checkIsFull(int capacity) {
        if (capacity == -1) {
            return false;
        }
        return this.players.size() >= capacity;
    }

    public int getNoOfHumanPlayers() {
        Collection<Player> thePlayers = this.players.values();
        int total = 0;
        for (Player player : thePlayers) {
            if (player.isRobot) continue;
            ++total;
        }
        return total;
    }

    public int getNoOfRobots() {
        Collection<Player> thePlayers = this.players.values();
        Collection<Table> theTables = this.tables.values();
        int total = 0;
        for (Player player : thePlayers) {
            if (!player.isRobot) continue;
            ++total;
        }
        for (Table table : theTables) {
            total += table.getNoOfRobots();
        }
        return total;
    }

    public boolean playerJoined(Player player) {
        Player existingPlayer = this.getPlayerByName(player.playerName);
        if (existingPlayer != null) {
            switch (LobbyWebSocketServer.lobbyWebSocketServer.config.duplicateNameTreatment) {
                case 2: {
                    existingPlayer.closeConnection();
                    break;
                }
                case 3: {
                    return false;
                }
            }
        }
        player.playerUID = this.generatePlayerUID();
        this.players.put(player.playerUID, player);
        player.room = this;
        List<Player> idlePlayers = this.getIdlePlayers();
        for (Player idlePlayer : idlePlayers) {
            if (idlePlayer == player) continue;
            idlePlayer.sendPlayerJoinedRoomMessage(player);
        }
        return true;
    }

    public Player getPlayerByName(String playerName) {
        Collection<Player> players = this.players.values();
        for (Player player : players) {
            if (!player.playerName.equals(playerName)) continue;
            return player;
        }
        return null;
    }

    public void removePlayer(Player player) {
        if (player != null) {
            this.removedPlayerUIDs.add(player.playerUID);
            if (player.table != null) {
                player.table.removePlayer(player);
                if (player.table.getHasPlayersOrViewers()) {
                    this.tablesWithRemovedPlayers.add(player.table);
                } else {
                    this.tables.remove(player.table.tableUID);
                }
            }
            this.players.remove(player.playerUID);
        }
    }

    public Table openTable(Player player, List<Integer> possibleNoOfPlayers, String tableID) {
        if (player.table != null) {
            return null;
        }
        if (tableID != null && this.getTableByTableID(tableID) != null) {
            return null;
        }
        String tableUID = this.generateTableUID();
        Table table = new Table(this, tableUID);
        table.possibleNoOfPlayers = possibleNoOfPlayers;
        table.players.add(player);
        table.tableID = tableID;
        this.tables.put(tableUID, table);
        List<Player> idlePlayers = this.getIdlePlayers();
        for (Player idlePlayer : idlePlayers) {
            if (idlePlayer == player) continue;
            idlePlayer.sendPlayerOpenedTableMessage(player, table);
        }
        return table;
    }

    public boolean joinTable(Player player, String tableUID) {
        Table joiningTable = this.tables.get(tableUID);
        if (joiningTable == null) {
            return false;
        }
        if (player.table != null) {
            this.leaveTable(player, player.table.tableUID);
        }
        if (!joiningTable.playerJoined(player)) {
            return false;
        }
        List<Player> idlePlayers = this.getIdlePlayers();
        for (Player idlePlayer : idlePlayers) {
            if (idlePlayer == player) continue;
            idlePlayer.sendPlayerJoinedTableMessage(player, joiningTable);
        }
        return true;
    }

    public boolean leaveTable(Player player, String tableUID) {
        if (player.table == null) {
            return false;
        }
        if (!player.table.tableUID.equals(tableUID)) {
            return false;
        }
        player.table.removePlayer(player);
        List<Player> idlePlayers = this.getIdlePlayers();
        for (Player playingPlayer : idlePlayers) {
            playingPlayer.sendPlayerLeftTableMessage(player, tableUID);
        }
        if (player.table.getHasPlayersOrViewers()) {
            if (player.table.isPlaying) {
                for (Player playingPlayer : player.table.players) {
                    if (playingPlayer == player) continue;
                    playingPlayer.sendPlayerLeftTableMessage(player, tableUID);
                }
            }
        } else {
            this.tables.remove(player.table.tableUID);
        }
        return true;
    }

    public boolean robotJoinTable(String tableUID) {
        Table table = this.tables.get(tableUID);
        if (table == null) {
            return false;
        }
        if (!table.robotJoined()) {
            return false;
        }
        List<Player> idlePlayers = this.getIdlePlayers();
        for (Player idlePlayer : idlePlayers) {
            idlePlayer.sendRobotJoinedTableMessage(table);
        }
        return true;
    }

    public boolean playerInvitesPlayer(Player player, String invitedPlayerUID) {
        if (player.table == null) {
            return false;
        }
        Player invitedPlayer = this.players.get(invitedPlayerUID);
        if (invitedPlayer == null) {
            return false;
        }
        invitedPlayer.sendInviteMessage(player, player.table);
        return true;
    }

    public boolean startPlaying(Player player, String tableUID) {
        Table table = player.table;
        if (table == null) {
            return false;
        }
        if (!table.tableUID.equals(tableUID)) {
            return false;
        }
        if (!table.getCanStartPlaying()) {
            return false;
        }
        ArrayList<Integer> randomSeeds = new ArrayList<Integer>();
        for (int i = 0; i < table.players.size(); ++i) {
            randomSeeds.add((int)Math.floor(Math.random() * 2.147483647E9));
        }
        List<Player> idlePlayers = this.getIdlePlayers();
        for (Player idlePlayer : idlePlayers) {
            idlePlayer.sendPlayingStartedMessage(table, randomSeeds);
        }
        table.startPlaying(this, randomSeeds);
        return true;
    }

    public void sendPlayersDisconnectedMessages() {
        if (this.removedPlayerUIDs.size() != 0) {
            List<Player> idlePlayers = this.getIdlePlayers();
            for (Player idlePlayer : idlePlayers) {
                idlePlayer.sendPlayersDisconnectedMessage(this.removedPlayerUIDs);
            }
            for (Table table : this.tablesWithRemovedPlayers) {
                table.sendPlayersDisconnectedMessages(this.removedPlayerUIDs);
            }
            this.removedPlayerUIDs.clear();
            this.tablesWithRemovedPlayers.clear();
        }
    }

    private String generatePlayerUID() {
        String dateString = this.getDateString();
        int i = 0;
        String playerUID;
        while (this.players.containsKey(playerUID = dateString + i)) {
            ++i;
        }
        return playerUID;
    }

    private String generateTableUID() {
        String dateString = this.getDateString();
        int i = 0;
        String tableUID;
        while (this.tables.containsKey(tableUID = dateString + i)) {
            ++i;
        }
        return tableUID;
    }

    private String getDateString() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        String dateString = "" + year;
        dateString = dateString + (Serializable)(month < 10 ? "0" + month : Integer.valueOf(month));
        dateString = dateString + (Serializable)(day < 10 ? "0" + day : Integer.valueOf(day));
        dateString = dateString + (Serializable)(hour < 10 ? "0" + hour : Integer.valueOf(hour));
        dateString = dateString + (Serializable)(minute < 10 ? "0" + minute : Integer.valueOf(minute));
        dateString = dateString + (Serializable)(second < 10 ? "0" + second : Integer.valueOf(second));
        return dateString;
    }

    private List<Player> getIdlePlayers() {
        ArrayList<Player> idlePlayers = new ArrayList<Player>();
        Collection<Player> players = this.players.values();
        for (Player player : players) {
            if (this.getPlayerIsInPlayingTable(player)) continue;
            idlePlayers.add(player);
        }
        return idlePlayers;
    }

    private boolean getPlayerIsInPlayingTable(Player player) {
        Table table;
        Collection<Table> tables = this.tables.values();
        Iterator<Table> var4 = tables.iterator();
        do {
            if (!var4.hasNext()) {
                return false;
            }
            table = var4.next();
        } while (!table.isPlaying || !table.getHasPlayer(player));
        return true;
    }

    private Table getPlayerTable(Player player) {
        Collection<Table> tables = this.tables.values();
        for (Table table : tables) {
            if (!table.getHasPlayer(player)) continue;
            return table;
        }
        return null;
    }

    private Table getTableByTableID(String tableID) {
        Collection<Table> tables = this.tables.values();
        for (Table table : tables) {
            if (!tableID.equals(table.tableID)) continue;
            return table;
        }
        return null;
    }
}

