/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

public class Table {
    public Room room;
    public String tableUID;
    public List<Integer> possibleNoOfPlayers;
    public String tableID;
    public List<Player> players;
    public List<Player> viewers;
    public boolean isPlaying;

    public Table(Room room, String tableUID) {
        this.room = room;
        this.tableUID = tableUID;
        this.players = new ArrayList<Player>();
        this.viewers = new ArrayList<Player>();
        this.isPlaying = false;
    }

    public int getNoOfRobots() {
        int total = 0;
        for (Player player : this.players) {
            if (!player.isRobot) continue;
            ++total;
        }
        return total;
    }

    public boolean playerJoined(Player player) {
        if (this.isPlaying) {
            return false;
        }
        int maxNoOfPlayers = this.possibleNoOfPlayers.get(this.possibleNoOfPlayers.size() - 1);
        if (this.players.size() >= maxNoOfPlayers) {
            return false;
        }
        this.players.add(player);
        player.table = this;
        return true;
    }

    public boolean robotJoined() {
        if (this.isPlaying) {
            return false;
        }
        int maxNoOfPlayers = this.possibleNoOfPlayers.get(this.possibleNoOfPlayers.size() - 1);
        if (this.players.size() >= maxNoOfPlayers) {
            return false;
        }
        Player robotPlayer = new Player(true);
        robotPlayer.table = this;
        this.players.add(robotPlayer);
        return true;
    }

    public void removePlayer(Player player) {
        if (!this.isPlaying) {
            this.players.remove(player);
        } else {
            int index = this.players.indexOf(player);
            if (index != -1) {
                this.players.set(index, player.createDisconnectedPlayer());
            }
        }
        this.viewers.remove(player);
    }

    public boolean getHasPlayersOrViewers() {
        for (Player player : this.players) {
            if (player.connection == null) continue;
            return true;
        }
        return this.viewers.size() > 0;
    }

    public boolean getHasPlayer(Player player) {
        if (this.players.contains(player)) {
            return true;
        }
        return this.viewers.contains(player);
    }

    public boolean getCanStartPlaying() {
        if (this.isPlaying) {
            return false;
        }
        int noOfPlayers = this.players.size();
        for (Integer possibleNo : this.possibleNoOfPlayers) {
            if (possibleNo != noOfPlayers) continue;
            return true;
        }
        return false;
    }

    public List<String> getPlayerUIDs() {
        ArrayList<String> playerUIDs = new ArrayList<String>();
        for (Player player : this.players) {
            playerUIDs.add(player.playerUID);
        }
        return playerUIDs;
    }

    public List<String> getViewerUIDs() {
        ArrayList<String> viewerUIDs = new ArrayList<String>();
        for (Player viewer : this.viewers) {
            viewerUIDs.add(viewer.playerUID);
        }
        return viewerUIDs;
    }

    public void startPlaying(Room room, List<Integer> randomSeeds) {
        for (int i = 0; i < this.players.size(); ++i) {
            Player player = this.players.get(i);
            player.randomSeed = randomSeeds.get(i);
        }
        this.isPlaying = true;
    }

    public void sendGameMessage(int playIndex, String message, String excludedPlayerUID) {
        for (Player viewer : this.players) {
            if (viewer.playerUID.equals(excludedPlayerUID)) continue;
            viewer.sendGameMessage(playIndex, message);
        }
        for (Player viewer : this.viewers) {
            viewer.sendGameMessage(playIndex, message);
        }
    }

    public void sendUpdateTimeMessage(int playIndex, int playerIndex, int time, String excludedPlayerUID) {
        for (Player viewer : this.players) {
            if (viewer.playerUID.equals(excludedPlayerUID)) continue;
            viewer.sendUpdateTimeMessage(playIndex, playerIndex, time);
        }
        for (Player viewer : this.viewers) {
            viewer.sendUpdateTimeMessage(playIndex, playerIndex, time);
        }
    }

    public void sendChatMessage(String message, String playerUID) {
        int i;
        for (i = 0; i < this.players.size() && !this.players.get((int)i).playerUID.equals(playerUID); ++i) {
        }
        int fromPlayerIndex = i;
        for (Player player : this.players) {
            player.sendChatMessage(message, fromPlayerIndex);
        }
    }

    public void sendPlayersDisconnectedMessages(List<String> playerUIDs) {
        for (Player player : this.players) {
            player.sendPlayersDisconnectedMessage(playerUIDs);
        }
        for (Player player : this.viewers) {
            player.sendPlayersDisconnectedMessage(playerUIDs);
        }
    }
}

