/*
 * Decompiled with CFR 0.152.
 */
package com.novelgames.lobbywebsocketserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonEncoder {
    public static String encode(Object theObject) throws Exception {
        if (theObject instanceof Map) {
            return JsonEncoder.encodeHashtable((Map)theObject);
        }
        if (theObject instanceof List) {
            return JsonEncoder.encodeArray((List)theObject);
        }
        if (theObject instanceof String) {
            return JsonEncoder.encodeString((String)theObject);
        }
        if (theObject instanceof Byte) {
            return JsonEncoder.encodeByte((Byte)theObject);
        }
        if (theObject instanceof Integer) {
            return JsonEncoder.encodeInteger((Integer)theObject);
        }
        if (theObject instanceof Float) {
            return JsonEncoder.encodeFloat(((Float)theObject).floatValue());
        }
        if (theObject instanceof Boolean) {
            return JsonEncoder.encodeBoolean((Boolean)theObject);
        }
        if (theObject == null) {
            return JsonEncoder.encodeNull();
        }
        throw new Exception();
    }

    public static Object decode(String jsonString) throws Exception {
        StringBuffer jsonStringBuffer = new StringBuffer(jsonString);
        Object result = JsonEncoder.decodeFromStringBuffer(jsonStringBuffer);
        JsonEncoder.skipSpaces(jsonStringBuffer);
        if (jsonStringBuffer.length() > 0) {
            throw new Exception();
        }
        return result;
    }

    private static String encodeHashtable(Map<String, Object> hashtable) throws Exception {
        StringBuffer result = new StringBuffer();
        result.append("{");
        Set<String> keys = hashtable.keySet();
        for (String key : keys) {
            if (result.length() != 1) {
                result.append(",");
            }
            result.append(JsonEncoder.encodeString(key));
            result.append(":");
            result.append(JsonEncoder.encode(hashtable.get(key)));
        }
        result.append("}");
        return result.toString();
    }

    private static String encodeArray(List<Object> array) throws Exception {
        StringBuffer result = new StringBuffer();
        result.append("[");
        int i = 0;
        while (i < array.size()) {
            if (i != 0) {
                result.append(",");
            }
            result.append(JsonEncoder.encode(array.get(i)));
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    private static String encodeString(String string) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        int i = 0;
        while (i < string.length()) {
            char theChar = string.charAt(i);
            switch (theChar) {
                case '\"': {
                    result.append("\\\"");
                    break;
                }
                case '\\': {
                    result.append("\\\\");
                    break;
                }
                case '\b': {
                    result.append("\\b");
                    break;
                }
                case '\t': {
                    result.append("\\t");
                    break;
                }
                case '\n': {
                    result.append("\\n");
                    break;
                }
                case '\f': {
                    result.append("\\f");
                    break;
                }
                case '\r': {
                    result.append("\\r");
                    break;
                }
                default: {
                    if (theChar < ' ' || theChar == '\u007f') {
                        result.append("\\u");
                        String hex = Integer.toHexString(theChar);
                        int j = hex.length();
                        while (j < 4) {
                            result.append('0');
                            ++j;
                        }
                        result.append(hex);
                        break;
                    }
                    result.append(theChar);
                }
            }
            ++i;
        }
        result.append("\"");
        return result.toString();
    }

    private static String encodeByte(byte value) {
        return "" + value;
    }

    private static String encodeInteger(int value) {
        return "" + value;
    }

    private static String encodeFloat(float value) {
        return "" + value;
    }

    private static String encodeBoolean(boolean value) {
        return value ? "true" : "false";
    }

    private static String encodeNull() {
        return "null";
    }

    private static Object decodeFromStringBuffer(StringBuffer jsonString) throws Exception {
        char firstChar = '\u0000';
        int i = 0;
        while (i < jsonString.length()) {
            firstChar = jsonString.charAt(i);
            if (firstChar != ' ' && firstChar != '\t' && firstChar != '\r' && firstChar != '\n') break;
            ++i;
        }
        if (i >= jsonString.length()) {
            return null;
        }
        jsonString.delete(0, i);
        switch (firstChar) {
            case '{': {
                return JsonEncoder.decodeObject(jsonString);
            }
            case '[': {
                return JsonEncoder.decodeArray(jsonString);
            }
            case '\"': {
                return JsonEncoder.decodeString(jsonString);
            }
            case 't': {
                return JsonEncoder.decodeTrue(jsonString);
            }
            case 'f': {
                return JsonEncoder.decodeFalse(jsonString);
            }
            case 'n': {
                return JsonEncoder.decodeNull(jsonString);
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return JsonEncoder.decodeNumber(jsonString);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static Map<String, Object> decodeObject(StringBuffer jsonString) throws Exception {
        result = new HashMap<String, Object>();
        theChar = jsonString.charAt(0);
        jsonString.deleteCharAt(0);
        if (theChar == '{') ** GOTO lbl45
        throw new Exception();
lbl-1000:
        // 1 sources

        {
            JsonEncoder.skipSpaces(jsonString);
            theChar = jsonString.charAt(0);
            if (theChar == '}') {
                jsonString.deleteCharAt(0);
                return result;
            }
            theChar = jsonString.charAt(0);
            if (theChar == '\"') {
                key = JsonEncoder.decodeString(jsonString);
            } else {
                i = 0;
                while (i < jsonString.length()) {
                    theChar = jsonString.charAt(i);
                    if (Character.isWhitespace(theChar) || theChar == ':') break;
                    ++i;
                }
                if (i == 0) {
                    throw new Exception();
                }
                key = jsonString.substring(0, i);
                jsonString.delete(0, i);
            }
            JsonEncoder.skipSpaces(jsonString);
            theChar = jsonString.charAt(0);
            if (theChar != ':') {
                throw new Exception();
            }
            jsonString.deleteCharAt(0);
            JsonEncoder.skipSpaces(jsonString);
            result.put(key, JsonEncoder.decodeFromStringBuffer(jsonString));
            JsonEncoder.skipSpaces(jsonString);
            theChar = jsonString.charAt(0);
            if (theChar == ',') {
                jsonString.deleteCharAt(0);
                continue;
            }
            if (theChar == '}') continue;
            throw new Exception();
lbl45:
            // 3 sources

            ** while (jsonString.length() > 0)
        }
lbl46:
        // 1 sources

        throw new Exception();
    }

    /*
     * Unable to fully structure code
     */
    private static List<Object> decodeArray(StringBuffer jsonString) throws Exception {
        result = new ArrayList<Object>();
        theChar = jsonString.charAt(0);
        jsonString.deleteCharAt(0);
        if (theChar == '[') ** GOTO lbl23
        throw new Exception();
lbl-1000:
        // 1 sources

        {
            JsonEncoder.skipSpaces(jsonString);
            theChar = jsonString.charAt(0);
            if (theChar == ']') {
                jsonString.deleteCharAt(0);
                return result;
            }
            result.add(JsonEncoder.decodeFromStringBuffer(jsonString));
            JsonEncoder.skipSpaces(jsonString);
            theChar = jsonString.charAt(0);
            if (theChar == ',') {
                jsonString.deleteCharAt(0);
                continue;
            }
            if (theChar == ']') continue;
            throw new Exception();
lbl23:
            // 3 sources

            ** while (jsonString.length() > 0)
        }
lbl24:
        // 1 sources

        throw new Exception();
    }

    /*
     * Unable to fully structure code
     */
    private static String decodeString(StringBuffer jsonString) throws Exception {
        stringBuffer = new StringBuffer();
        theChar = jsonString.charAt(0);
        jsonString.deleteCharAt(0);
        if (theChar == '\"') ** GOTO lbl65
        throw new Exception();
lbl-1000:
        // 1 sources

        {
            theChar = jsonString.charAt(0);
            jsonString.deleteCharAt(0);
            block0 : switch (theChar) {
                case '\"': {
                    return stringBuffer.toString();
                }
                case '\\': {
                    if (jsonString.length() == 0) {
                        throw new Exception();
                    }
                    theChar = jsonString.charAt(0);
                    jsonString.deleteCharAt(0);
                    switch (theChar) {
                        case '\"': {
                            stringBuffer.append('\"');
                            break block0;
                        }
                        case '\\': {
                            stringBuffer.append('\\');
                            break block0;
                        }
                        case '/': {
                            stringBuffer.append('/');
                            break block0;
                        }
                        case 'b': {
                            stringBuffer.append('\b');
                            break block0;
                        }
                        case 'f': {
                            stringBuffer.append('\f');
                            break block0;
                        }
                        case 'n': {
                            stringBuffer.append('\n');
                            break block0;
                        }
                        case 'r': {
                            stringBuffer.append('\r');
                            break block0;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            break block0;
                        }
                        case 'u': {
                            if (jsonString.length() < 4) {
                                throw new Exception();
                            }
                            hex = jsonString.substring(0, 4);
                            jsonString.delete(0, 4);
                            stringBuffer.append((char)Integer.valueOf(hex, 16).shortValue());
                            break block0;
                        }
                    }
                    throw new Exception();
                }
                default: {
                    stringBuffer.append(theChar);
                }
            }
lbl65:
            // 11 sources

            ** while (jsonString.length() > 0)
        }
lbl66:
        // 1 sources

        throw new Exception();
    }

    private static boolean decodeTrue(StringBuffer jsonString) throws Exception {
        if (jsonString.length() < 4 || !"true".equals(jsonString.substring(0, 4))) {
            throw new Exception();
        }
        jsonString.delete(0, 4);
        return true;
    }

    private static Boolean decodeFalse(StringBuffer jsonString) throws Exception {
        if (jsonString.length() < 5 || !"false".equals(jsonString.substring(0, 5))) {
            throw new Exception();
        }
        jsonString.delete(0, 5);
        return false;
    }

    private static Object decodeNull(StringBuffer jsonString) throws Exception {
        if (jsonString.length() < 4 || !"null".equals(jsonString.substring(0, 4))) {
            throw new Exception();
        }
        jsonString.delete(0, 4);
        return null;
    }

    private static Object decodeNumber(StringBuffer jsonString) throws Exception {
        Pattern pattern = Pattern.compile("-?(0|[1-9]\\d*)(\\.\\d+)?([eE][+-]?\\d+)?");
        Matcher matcher = pattern.matcher(jsonString);
        if (!matcher.find() || matcher.start() != 0) {
            throw new Exception();
        }
        int end = matcher.end();
        String numberString = jsonString.substring(0, end);
        jsonString.delete(0, end);
        if (numberString.indexOf(46) != -1) {
            return new Float(numberString);
        }
        return new Integer(numberString);
    }

    private static void skipSpaces(StringBuffer jsonString) {
        while (jsonString.length() > 0) {
            char theChar = jsonString.charAt(0);
            if (!Character.isWhitespace(theChar)) {
                return;
            }
            jsonString.deleteCharAt(0);
        }
    }
}

