/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Connection {
    private static int BUFFERSIZE = 16;
    private LobbyWebSocketServer lobbyWebSocketServer;
    private ConnectionsManager playerManager;
    private SocketChannel socketChannel;
    private ByteBuffer byteBuffer;
    private boolean firstHttpRead;
    private List<String> firstHttpLines;
    public boolean shouldBeRemoved;
    private long lastReceiveTime;
    private long sendPingTime;
    public String extraKey;
    public Player player;

    public Connection(ConnectionsManager playerManager, SocketChannel socketChannel) {
        this.lobbyWebSocketServer = playerManager.lobbyWebSocketServer;
        this.playerManager = playerManager;
        this.socketChannel = socketChannel;
        this.byteBuffer = ByteBuffer.allocate(BUFFERSIZE);
        this.byteBuffer.mark();
        this.firstHttpRead = false;
        this.shouldBeRemoved = false;
        this.lastReceiveTime = 0L;
        this.sendPingTime = 0L;
    }

    public void close() {
        this.shouldBeRemoved = true;
        try {
            this.sendFrame(Frame.createCloseFrame());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void disconnect() {
        try {
            this.socketChannel.socket().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendPingIfNeeded() {
        if (this.lastReceiveTime != 0L && this.sendPingTime == 0L && new Date().getTime() - this.lastReceiveTime > (long)this.lobbyWebSocketServer.config.noReceiveSendPingTime) {
            try {
                this.sendFrame(Frame.createPingFrame());
                this.sendPingTime = new Date().getTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean getSentPingButNoPongReceived() {
        if (this.sendPingTime == 0L) {
            return false;
        }
        return new Date().getTime() - this.sendPingTime > (long)this.lobbyWebSocketServer.config.maxWaitPongTime;
    }

    public void processInput() throws Exception {
        List<Frame> frames = null;
        this.lobbyWebSocketServer.writeLog("processInput A");
        this.lastReceiveTime = new Date().getTime();
        try {
            boolean closed = this.readSocketChannel();
            if (closed) {
                this.shouldBeRemoved = true;
            }
            if (this.firstHttpRead) {
                while (true) {
                    this.lobbyWebSocketServer.writeLog("processInput C");
                    this.flipByteBufferToMark();
                    frames = Frame.readFrames(this.byteBuffer);
                    this.lobbyWebSocketServer.writeLog("processInput D");
                    if (frames == null) {
                        this.lobbyWebSocketServer.writeLog("processInput E");
                        this.prepareByteBufferForWriting();
                        return;
                    }
                    this.lobbyWebSocketServer.writeLog("processInput F");
                    this.finishReadingByteBuffer();
                    if (frames.get(0).getIsClose()) {
                        this.shouldBeRemoved = true;
                        return;
                    }
                    if (frames.get(0).getIsPing()) {
                        this.sendFrame(Frame.createPongFrame(frames.get(0)));
                        continue;
                    }
                    if (frames.get(0).getIsPong()) {
                        this.sendPingTime = 0L;
                        continue;
                    }
                    this.processLobbyInput(Frame.getFramesPayloadAsString(frames));
                }
            }
            this.lobbyWebSocketServer.writeLog("processInput B");
            this.flipByteBufferToMark();
            List<String> httpLines = this.getHttpLines();
            if (httpLines == null) {
                this.prepareByteBufferForWriting();
                return;
            }
            this.finishReadingByteBuffer();
            this.firstHttpRead = true;
            this.firstHttpLines = httpLines;
            if (this.getHttpLinesIsNormalHttp(httpLines)) {
                this.processNormalHttp(httpLines);
                this.shouldBeRemoved = true;
            } else {
                this.sendWebSocketHandshake(httpLines);
            }
        }
        catch (Exception var7) {
            this.lobbyWebSocketServer.writeLog("processInput R");
            this.lobbyWebSocketServer.writeLog(var7);
            this.lobbyWebSocketServer.writeLog(this.getPlayerInfo());
            if (this.firstHttpLines != null) {
                for (String line : this.firstHttpLines) {
                    this.lobbyWebSocketServer.writeLog(line);
                }
            }
            this.lobbyWebSocketServer.writeLog("byteBuffer");
            for (int i = 0; i < this.byteBuffer.capacity(); ++i) {
                this.lobbyWebSocketServer.writeLog(String.valueOf(this.byteBuffer.get(i)));
            }
            if (frames != null) {
                this.lobbyWebSocketServer.writeLog("frames.size() = " + frames.size());
                for (Frame frame : frames) {
                    this.lobbyWebSocketServer.writeLog("frame");
                    this.lobbyWebSocketServer.writeLog("frame.byteBuffer.limit() = " + frame.byteBuffer.limit());
                    this.lobbyWebSocketServer.writeLog("frame.payloadLength = " + frame.payloadLength);
                }
            }
            this.shouldBeRemoved = true;
        }
        this.lobbyWebSocketServer.writeLog("processInput Z");
    }

    private boolean readSocketChannel() throws Exception {
        long noOfBytes;
        while ((noOfBytes = (long)this.socketChannel.read(this.byteBuffer)) != -1L) {
            if (this.byteBuffer.remaining() > 0) {
                return false;
            }
            this.increaseBufferSize();
        }
        return true;
    }

    private void increaseBufferSize() {
        ByteBuffer newByteBuffer = ByteBuffer.allocate(this.byteBuffer.capacity() + BUFFERSIZE);
        newByteBuffer.mark();
        this.byteBuffer.limit(this.byteBuffer.position());
        this.byteBuffer.reset();
        newByteBuffer.put(this.byteBuffer);
        this.byteBuffer = newByteBuffer;
    }

    private void flipByteBufferToMark() {
        this.byteBuffer.limit(this.byteBuffer.position());
        this.byteBuffer.reset();
    }

    private void prepareByteBufferForWriting() {
        this.byteBuffer.reset();
        if (this.byteBuffer.hasRemaining()) {
            this.byteBuffer.position(this.byteBuffer.limit());
            this.byteBuffer.limit(this.byteBuffer.capacity());
        } else {
            this.byteBuffer.clear();
            this.byteBuffer.mark();
        }
    }

    private void finishReadingByteBuffer() {
        this.byteBuffer.mark();
        this.prepareByteBufferForWriting();
    }

    private List<String> getHttpLines() throws Exception {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        boolean finished = false;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.byteBuffer.array(), this.byteBuffer.position(), this.byteBuffer.remaining()), "utf-8"));
        while ((line = reader.readLine()) != null) {
            if (finished) {
                this.lobbyWebSocketServer.writeLog("getHttpLines A");
                this.lobbyWebSocketServer.writeLog("handshake content:");
                this.lobbyWebSocketServer.writeLog(line);
            }
            if (line.equals("")) {
                finished = true;
            }
            lines.add(line);
        }
        this.byteBuffer.position(this.byteBuffer.limit());
        if (!finished) {
            return null;
        }
        return lines;
    }

    private boolean getHttpLinesIsNormalHttp(List<String> httpLines) {
        boolean hasUpgradeWebSocket = false;
        boolean hasConnectionUpgrade = false;
        Iterator<String> var6 = httpLines.iterator();
        while (var6.hasNext()) {
            String line = var6.next();
            String[] nameValue = line.split("\\s*:\\s*", 2);
            if (nameValue.length != 2) continue;
            if ("Upgrade".equalsIgnoreCase(nameValue[0]) && this.getHttpHeaderContainsValue(nameValue[1], "websocket")) {
                hasUpgradeWebSocket = true;
                continue;
            }
            if (!"Connection".equalsIgnoreCase(nameValue[0]) || !this.getHttpHeaderContainsValue(nameValue[1], "Upgrade")) continue;
            hasConnectionUpgrade = true;
        }
        return !hasUpgradeWebSocket || !hasConnectionUpgrade;
    }

    private boolean getHttpHeaderContainsValue(String headerValue, String containsValue) {
        String[] headerValues;
        String[] var7 = headerValues = headerValue.split("\\s*,\\s*");
        int var6 = headerValues.length;
        for (int var5 = 0; var5 < var6; ++var5) {
            String theHeaderValue = var7[var5];
            if (!theHeaderValue.equalsIgnoreCase(containsValue)) continue;
            return true;
        }
        return false;
    }

    private void processNormalHttp(List<String> httpLines) throws Exception {
        try {
            String parameters;
            Pattern pattern = Pattern.compile("\\s+(.*?)\\s+");
            Matcher matcher = pattern.matcher(httpLines.get(0));
            if (!matcher.find()) {
                throw new Exception();
            }
            String pathParameters = matcher.group(1);
            String[] parts = pathParameters.split("\\?", 2);
            String path = parts[0];
            String string = parameters = parts.length > 1 ? parts[1] : null;
            if (!"/getPlayerCounts".equals(path)) {
                throw new Exception();
            }
            this.processGetPlayerCounts(parameters);
        }
        catch (Exception var9) {
            this.sendErrorHttpResponse(500);
        }
    }

    private void processGetPlayerCounts(String parametersString) throws Exception {
        Map<String, String> parameters = this.decodeParameters(parametersString);
        String siteID = parameters.get("siteID");
        String gameID = parameters.get("gameID");
        Site site = this.lobbyWebSocketServer.getSite(siteID);
        Game game = site.getGame(gameID);
        StringBuffer content = new StringBuffer();
        content.append('[');
        for (Room room : game.rooms) {
            if (room == null) continue;
            if (content.length() > 1) {
                content.append(',');
            }
            content.append('{');
            content.append("\"roomID\":");
            content.append(room.roomID);
            content.append(",\"noOfHumanPlayers\":");
            content.append(room.getNoOfHumanPlayers());
            content.append(",\"noOfRobots\":");
            content.append(room.getNoOfRobots());
            content.append('}');
        }
        content.append(']');
        StringBuffer response = new StringBuffer();
        response.append("HTTP/1.0 200 OK\r\n");
        response.append("Content-Type: application/json\r\n");
        response.append("Content-Length:").append(content.length()).append("\r\n\r\n");
        response.append(content);
        byte[] responseBytes = response.toString().getBytes("utf-8");
        ByteBuffer byteBuffer = ByteBuffer.wrap(responseBytes);
        this.socketChannel.write(byteBuffer);
    }

    private void sendErrorHttpResponse(int statusCode) throws Exception {
        String statusName;
        switch (statusCode) {
            case 500: {
                statusName = "Internal Server Error";
                break;
            }
            default: {
                statusName = "";
            }
        }
        String response = "HTTP/1.0 " + statusCode + " " + statusName + "\r\n\r\n";
        byte[] responseBytes = response.getBytes("utf-8");
        this.byteBuffer = ByteBuffer.wrap(responseBytes);
        this.socketChannel.write(this.byteBuffer);
    }

    private void sendWebSocketHandshake(List<String> httpLines) throws Exception {
        String acceptValue = null;
        for (String line : httpLines) {
            String[] nameValue = line.split("\\s*:\\s*", 2);
            if (nameValue.length != 2 || !"Sec-WebSocket-Key".equalsIgnoreCase(nameValue[0])) continue;
            acceptValue = this.getAcceptValue(nameValue[1]);
        }
        String response = "HTTP/1.1 101 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\nSec-WebSocket-Accept: " + acceptValue + "\r\n\r\n";
        byte[] responseBytes = response.getBytes("utf-8");
        ByteBuffer byteBuffer = ByteBuffer.wrap(responseBytes);
        this.socketChannel.write(byteBuffer);
    }

    private String getAcceptValue(String key) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] sha1 = messageDigest.digest((key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes("utf-8"));
        return Base64.getEncoder().encodeToString(sha1);
    }

    private void sendFrame(Frame frame) throws Exception {
        this.socketChannel.write(frame.byteBuffer);
    }

    private void processLobbyInput(String input) throws Exception {
        this.lobbyWebSocketServer.writeLog("processLobbyInput A");
        this.lobbyWebSocketServer.writeLog(input);
        Map<String, String> parameters = this.decodeParameters(input);
        parameters = this.decryptParameters(parameters);
        if (!this.checkHash(parameters)) {
            throw new Exception("hash incorrect: input = " + input);
        }
        String action = parameters.get("action");
        if ("joinRoom".equals(action)) {
            this.lobbyWebSocketServer.writeLog("processLobbyInput B");
            this.processJoinRoom(parameters);
        } else if ("openTable".equals(action)) {
            this.lobbyWebSocketServer.writeLog("processLobbyInput C");
            this.processOpenTable(parameters);
        } else if ("joinTable".equals(action)) {
            this.lobbyWebSocketServer.writeLog("processLobbyInput D");
            this.processJoinTable(parameters);
        } else if ("leaveTable".equals(action)) {
            this.lobbyWebSocketServer.writeLog("processLobbyInput E");
            this.processLeaveTable(parameters);
        } else if ("invite".equals(action)) {
            this.lobbyWebSocketServer.writeLog("processLobbyInput F");
            this.processInvite(parameters);
        } else if ("robotJoinTable".equals(action)) {
            this.lobbyWebSocketServer.writeLog("processLobbyInput G");
            this.processRobotJoinTable(parameters);
        } else if ("startPlaying".equals(action)) {
            this.lobbyWebSocketServer.writeLog("processLobbyInput H");
            this.processStartPlaying(parameters);
        } else if ("sendGameMessage".equals(action)) {
            this.lobbyWebSocketServer.writeLog("processLobbyInput I");
            this.processSendGameMessage(parameters);
        } else if ("updateTime".equals(action)) {
            this.lobbyWebSocketServer.writeLog("processLobbyInput J");
            this.processUpdateTime(parameters);
        } else if ("sendChatMessage".equals(action)) {
            this.lobbyWebSocketServer.writeLog("processLobbyInput K");
            this.processSendChatMessage(parameters);
        } else if ("gameEnded".equals(action)) {
            this.lobbyWebSocketServer.writeLog("processLobbyInput L");
            this.processGameEnded(parameters);
        }
        this.lobbyWebSocketServer.writeLog("processLobbyInput Z");
    }

    private Map<String, String> decodeParameters(String input) throws Exception {
        String[] parts;
        HashMap<String, String> parameters = new HashMap<String, String>();
        String[] var10 = parts = input.split("&");
        int var9 = parts.length;
        for (int var8 = 0; var8 < var9; ++var8) {
            String part = var10[var8];
            String[] keyValue = part.split("=");
            String key = URLDecoder.decode(keyValue[0], "UTF-8");
            String value = keyValue.length > 1 ? URLDecoder.decode(keyValue[1], "UTF-8") : "";
            parameters.put(key, value);
        }
        return parameters;
    }

    private Map<String, String> decryptParameters(Map<String, String> parameters) throws Exception {
        String encryptedParameters = parameters.get("encryptedParameters");
        if (encryptedParameters == null) {
            return parameters;
        }
        String decryptedParameters = this.decryptEncryptedParameters(encryptedParameters);
        return this.decodeParameters(decryptedParameters);
    }

    private String decryptEncryptedParameters(String encryptedParameters) {
        int i;
        int hashKeyLength = this.lobbyWebSocketServer.config.hashKey.length();
        int[] encryptKey = new int[(hashKeyLength + 3) / 3 * 3];
        for (i = 0; i < hashKeyLength; ++i) {
            encryptKey[i] = this.lobbyWebSocketServer.config.hashKey.charAt(i);
        }
        while (i < encryptKey.length) {
            encryptKey[i] = 0;
            ++i;
        }
        int encryptedParametersLength = encryptedParameters.length();
        StringBuffer result = new StringBuffer();
        for (i = 0; i < encryptedParametersLength; i += 2) {
            int charCode = Integer.parseInt(encryptedParameters.substring(i, i + 2), 16);
            charCode += 256 - encryptKey[i / 2 * 3 % encryptKey.length];
            result.append((char)(charCode %= 256));
        }
        return result.toString();
    }

    private boolean checkHash(Map<String, String> parameters) throws Exception {
        String hash = parameters.get("hash");
        if (hash == null) {
            return false;
        }
        TreeMap<String, String> sortedParameters = new TreeMap<String, String>();
        Set<String> keys = parameters.keySet();
        for (String value : keys) {
            if ("hash".equals(value)) continue;
            sortedParameters.put(value, parameters.get(value));
        }
        Collection values = sortedParameters.values();
        StringBuffer stringToHash = new StringBuffer();
        for (String value : values) {
            stringToHash.append(value);
        }
        stringToHash.append(this.lobbyWebSocketServer.config.hashKey);
        if (this.extraKey != null) {
            stringToHash.append(this.extraKey);
        }
        return true;
    }

    public static String getMD5(byte[] bytes) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(bytes);
            byte[] digest = messageDigest.digest();
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < digest.length; ++i) {
                String hex = Integer.toHexString(0xFF & digest[i]);
                if (hex.length() == 1) {
                    result.append('0');
                }
                result.append(hex);
            }
            return result.toString();
        }
        catch (Exception var7) {
            return null;
        }
    }

    private void processJoinRoom(Map<String, String> parameters) throws Exception {
        String siteID = parameters.get("siteID");
        String gameID = parameters.get("gameID");
        if (siteID != null && gameID != null) {
            int roomCapacity;
            String roomID = parameters.get("roomID");
            if (roomID == null || roomID.equals("")) {
                roomID = "1";
            }
            try {
                roomCapacity = Integer.parseInt(parameters.get("roomCapacity"));
            }
            catch (Exception var11) {
                roomCapacity = -1;
            }
            Site site = this.lobbyWebSocketServer.getSite(siteID);
            Game game = site.getGame(gameID);
            Room room = game.getRoom(Integer.parseInt(roomID));
            if (room.checkIsFull(roomCapacity)) {
                HashMap<String, Object> returnResult = new HashMap<String, Object>();
                returnResult.put("success", false);
                returnResult.put("reason", "roomFull");
                this.sendFrame(Frame.createTextFrame(JsonEncoder.encode(returnResult)));
            } else {
                this.player = new Player(this);
                this.player.playerID = parameters.get("playerID");
                this.player.playerName = parameters.get("playerName");
                this.player.playerEmail = parameters.get("playerEmail");
                this.player.playerPictureURL = parameters.get("playerPictureURL");
                this.player.playerFacebookUserID = parameters.get("playerFacebookUserID");
                this.player.playerTwitterUserID = parameters.get("playerTwitterUserID");
                this.player.playerGoogleUserID = parameters.get("playerGoogleUserID");
                if (this.player.playerName == null) {
                    this.player.playerName = "";
                }
                if (!room.playerJoined(this.player)) {
                    HashMap<String, Boolean> returnResult = new HashMap<String, Boolean>();
                    returnResult.put("success", false);
                    this.sendFrame(Frame.createTextFrame(JsonEncoder.encode(returnResult)));
                } else {
                    this.generateExtraKey();
                    HashMap<String, Object> returnResult = new HashMap<String, Object>();
                    returnResult.put("success", true);
                    returnResult.put("playerUID", this.player.playerUID);
                    returnResult.put("extraKey", this.extraKey);
                    returnResult.put("players", this.getRoomPlayerInfos());
                    returnResult.put("tables", this.getRoomTableInfos());
                    this.sendFrame(Frame.createTextFrame(JsonEncoder.encode(returnResult)));
                }
            }
        } else {
            throw new Exception();
        }
    }

    private List<Map<String, Object>> getRoomPlayerInfos() {
        ArrayList<Map<String, Object>> infos = new ArrayList<Map<String, Object>>();
        Collection<Player> roomPlayers = this.player.room.players.values();
        for (Player roomPlayer : roomPlayers) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("playerUID", roomPlayer.playerUID);
            info.put("playerName", roomPlayer.playerName);
            info.put("playerPictureURL", roomPlayer.playerPictureURL != null ? roomPlayer.playerPictureURL : "");
            infos.add(info);
        }
        return infos;
    }

    private List<Map<String, Object>> getRoomTableInfos() {
        ArrayList<Map<String, Object>> infos = new ArrayList<Map<String, Object>>();
        Collection<Table> roomTables = this.player.room.tables.values();
        for (Table roomTable : roomTables) {
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("tableUID", roomTable.tableUID);
            info.put("possibleNoOfPlayers", roomTable.possibleNoOfPlayers);
            info.put("playerUIDs", roomTable.getPlayerUIDs());
            info.put("viewerUIDs", roomTable.getViewerUIDs());
            info.put("isPlaying", roomTable.isPlaying);
            if (roomTable.tableID != null) {
                info.put("tableID", roomTable.tableID);
            }
            infos.add(info);
        }
        return infos;
    }

    public void generateExtraKey() {
        String extraKeyCharacters = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int extraKeyLength = this.lobbyWebSocketServer.config.extraKeyLength;
        StringBuffer extraKey = new StringBuffer();
        for (int i = 0; i < extraKeyLength; ++i) {
            extraKey.append(extraKeyCharacters.charAt((int)Math.floor(Math.random() * (double)extraKeyCharacters.length())));
        }
        this.extraKey = extraKey.toString();
    }

    private void processOpenTable(Map<String, String> parameters) {
        if (this.player.room != null && this.player.table == null) {
            Table table;
            String[] parts = parameters.get("possibleNoOfPlayers").split(",");
            ArrayList<Integer> possibleNoOfPlayers = new ArrayList<Integer>();
            String[] var9 = parts;
            int var8 = parts.length;
            for (int var7 = 0; var7 < var8; ++var7) {
                String part = var9[var7];
                possibleNoOfPlayers.add(Integer.parseInt(part));
            }
            this.player.table = table = this.player.room.openTable(this.player, possibleNoOfPlayers, parameters.get("tableID"));
            HashMap<String, Object> resultParameters = new HashMap<String, Object>();
            resultParameters.put("action", "openTableResult");
            if (table != null) {
                resultParameters.put("success", true);
                resultParameters.put("tableUID", table.tableUID);
            } else {
                resultParameters.put("success", false);
            }
            try {
                this.sendFrame(Frame.createTextFrame(JsonEncoder.encode(resultParameters)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void processJoinTable(Map<String, String> parameters) {
        String tableUID = parameters.get("tableUID");
        boolean requestRoomInfo = "true".equals(parameters.get("requestRoomInfo"));
        boolean success = this.player.room.joinTable(this.player, tableUID);
        HashMap<String, Object> resultParameters = new HashMap<String, Object>();
        resultParameters.put("action", "joinTableResult");
        resultParameters.put("success", success);
        if (requestRoomInfo) {
            resultParameters.put("players", this.getRoomPlayerInfos());
            resultParameters.put("tables", this.getRoomTableInfos());
        }
        try {
            this.sendFrame(Frame.createTextFrame(JsonEncoder.encode(resultParameters)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processLeaveTable(Map<String, String> parameters) {
        String tableUID = parameters.get("tableUID");
        boolean success = this.player.room != null && this.player.room.leaveTable(this.player, tableUID);
        HashMap<String, Object> resultParameters = new HashMap<String, Object>();
        resultParameters.put("action", "leaveTableResult");
        resultParameters.put("success", success);
        resultParameters.put("players", this.getRoomPlayerInfos());
        resultParameters.put("tables", this.getRoomTableInfos());
        try {
            this.sendFrame(Frame.createTextFrame(JsonEncoder.encode(resultParameters)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processInvite(Map<String, String> parameters) {
        String invitedPlayerUID = parameters.get("invitedPlayerUID");
        boolean success = this.player.room.playerInvitesPlayer(this.player, invitedPlayerUID);
        HashMap<String, Object> resultParameters = new HashMap<String, Object>();
        resultParameters.put("action", "inviteResult");
        resultParameters.put("success", success);
        try {
            this.sendFrame(Frame.createTextFrame(JsonEncoder.encode(resultParameters)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processRobotJoinTable(Map<String, String> parameters) {
        boolean success = this.player.room.robotJoinTable(parameters.get("tableUID"));
        HashMap<String, Object> resultParameters = new HashMap<String, Object>();
        resultParameters.put("action", "robotJoinTableResult");
        resultParameters.put("success", success);
        try {
            this.sendFrame(Frame.createTextFrame(JsonEncoder.encode(resultParameters)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processStartPlaying(Map<String, String> parameters) {
        String tableUID = parameters.get("tableUID");
        boolean success = this.player.room.startPlaying(this.player, tableUID);
        HashMap<String, Object> resultParameters = new HashMap<String, Object>();
        resultParameters.put("action", "startPlayingResult");
        resultParameters.put("success", success);
        try {
            this.sendFrame(Frame.createTextFrame(JsonEncoder.encode(resultParameters)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processSendGameMessage(Map<String, String> parameters) {
        int playIndex = Integer.parseInt(parameters.get("playIndex"));
        String message = parameters.get("message");
        this.player.table.sendGameMessage(playIndex, message, this.player.playerUID);
    }

    private void processUpdateTime(Map<String, String> parameters) {
        if (this.player.table != null) {
            int playIndex = Integer.parseInt(parameters.get("playIndex"));
            int playerIndex = Integer.parseInt(parameters.get("playerIndex"));
            int time = Integer.parseInt(parameters.get("time"));
            this.player.table.sendUpdateTimeMessage(playIndex, playerIndex, time, this.player.playerUID);
        }
    }

    private void processSendChatMessage(Map<String, String> parameters) {
        this.player.table.sendChatMessage(parameters.get("message"), this.player.playerUID);
    }

    private void processGameEnded(Map<String, String> parameters) {
        this.recordResults(parameters);
        HashMap<String, Object> resultParameters = new HashMap<String, Object>();
        resultParameters.put("action", "gameEndedResult");
        resultParameters.put("success", true);
        try {
            this.sendFrame(Frame.createTextFrame(JsonEncoder.encode(resultParameters)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recordResults(Map<String, String> parameters) {
        List ranks = null;
        int playerIndex = -1;
        try {
            List<String> recordResultsCommandArguments = this.lobbyWebSocketServer.config.recordResultsCommandArguments;
            if (recordResultsCommandArguments == null || recordResultsCommandArguments.size() == 0) {
                return;
            }
            if (this.player == null) {
                return;
            }
            if (this.player.table == null) {
                return;
            }
            int playIndex = Integer.parseInt(parameters.get("playIndex"));
            ranks = (List)JsonEncoder.decode("[" + parameters.get("ranks") + "]");
            String customExtra = parameters.get("customExtra");
            ArrayList<String> playerNames = new ArrayList<String>();
            ArrayList<String> playerEmails = new ArrayList<String>();
            ArrayList<String> playerIDs = new ArrayList<String>();
            ArrayList<String> playerFacebookUserIDs = new ArrayList<String>();
            ArrayList<String> playerTwitterUserIDs = new ArrayList<String>();
            ArrayList<String> playerGoogleUserIDs = new ArrayList<String>();
            for (int i = 0; i < this.player.table.players.size(); ++i) {
                Player thePlayer = this.player.table.players.get(i);
                playerNames.add(thePlayer.playerName);
                playerEmails.add(thePlayer.playerEmail);
                playerIDs.add(thePlayer.playerID);
                playerFacebookUserIDs.add(thePlayer.playerFacebookUserID);
                playerTwitterUserIDs.add(thePlayer.playerTwitterUserID);
                playerGoogleUserIDs.add(thePlayer.playerGoogleUserID);
                if (thePlayer != this.player) continue;
                playerIndex = i;
            }
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put("siteID", this.player.table.room.game.site.siteID);
            results.put("gameID", this.player.table.room.game.gameID);
            results.put("roomID", this.player.table.room.roomID);
            results.put("tableUID", this.player.table.tableUID);
            results.put("tableID", this.player.table.tableID);
            results.put("playIndex", playIndex);
            results.put("playerNames", playerNames);
            results.put("playerEmails", playerEmails);
            results.put("playerIDs", playerIDs);
            results.put("playerFacebookUserIDs", playerFacebookUserIDs);
            results.put("playerTwitterUserIDs", playerTwitterUserIDs);
            results.put("playerGoogleUserIDs", playerGoogleUserIDs);
            results.put("ranks", ranks);
            results.put("playerIndex", playerIndex);
            results.put("customExtra", customExtra);
            String resultsJson = JsonEncoder.encode(results);
            new ProcessRunner(recordResultsCommandArguments, resultsJson).start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendPlayerJoinedRoomMessage(Player player) {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("action", "playerJoinedRoom");
            parameters.put("playerUID", player.playerUID);
            parameters.put("playerName", player.playerName);
            parameters.put("playerPictureURL", player.playerPictureURL != null ? player.playerPictureURL : "");
            String message = JsonEncoder.encode(parameters);
            Frame frame = Frame.createTextFrame(message);
            this.sendFrame(frame);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendPlayerOpenedTableMessage(Player player, Table table) {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("action", "playerOpenedTable");
            parameters.put("playerUID", player.playerUID);
            parameters.put("tableUID", table.tableUID);
            parameters.put("possibleNoOfPlayers", table.possibleNoOfPlayers);
            String message = JsonEncoder.encode(parameters);
            Frame frame = Frame.createTextFrame(message);
            this.sendFrame(frame);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendPlayerJoinedTableMessage(Player player, Table table) {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("action", "playerJoinedTable");
            parameters.put("playerUID", player.playerUID);
            parameters.put("tableUID", table.tableUID);
            this.sendFrame(Frame.createTextFrame(JsonEncoder.encode(parameters)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendPlayerLeftTableMessage(Player player, String tableUID) {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("action", "playerLeftTable");
            parameters.put("playerUID", player.playerUID);
            parameters.put("tableUID", tableUID);
            this.sendFrame(Frame.createTextFrame(JsonEncoder.encode(parameters)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendRobotJoinedTableMessage(Table table) {
        int noOfRobots = 0;
        for (Player player : table.players) {
            if (!player.isRobot) continue;
            ++noOfRobots;
        }
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("action", "robotJoinedTable");
            parameters.put("tableUID", table.tableUID);
            parameters.put("noOfRobots", noOfRobots);
            this.sendFrame(Frame.createTextFrame(JsonEncoder.encode(parameters)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendInviteMessage(Player player, Table table) {
        try {
            HashMap<Object, String> parameters = new HashMap<Object, String>();
            parameters.put("action", "invite");
            parameters.put("playerUID", player.playerUID);
            parameters.put("tableUID", table.tableUID);
            for (int i = 0; i < table.players.size(); ++i) {
                parameters.put("tablePlayerUID" + i, table.players.get((int)i).playerUID);
                parameters.put("tablePlayerName" + i, table.players.get((int)i).playerName);
            }
            this.sendFrame(Frame.createTextFrame(JsonEncoder.encode(parameters)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendPlayingStartedMessage(Table table, List<Integer> randomSeeds) {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("action", "playingStarted");
            parameters.put("tableUID", table.tableUID);
            parameters.put("randomSeeds", randomSeeds);
            this.sendFrame(Frame.createTextFrame(JsonEncoder.encode(parameters)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendGameMessage(int playIndex, String message) {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("action", "gameMessageReceived");
            parameters.put("playIndex", playIndex);
            parameters.put("message", message);
            this.sendFrame(Frame.createTextFrame(JsonEncoder.encode(parameters)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendUpdateTimeMessage(int playIndex, int playerIndex, int time) {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("action", "playerTimeUpdated");
            parameters.put("playIndex", playIndex);
            parameters.put("playerIndex", playerIndex);
            parameters.put("time", time);
            this.sendFrame(Frame.createTextFrame(JsonEncoder.encode(parameters)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendChatMessage(String message, int fromPlayerIndex) {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("action", "chatMessageReceived");
            parameters.put("message", message);
            parameters.put("fromPlayerIndex", fromPlayerIndex);
            LobbyWebSocketServer.lobbyWebSocketServer.writeLog("sendChatMessage A");
            this.sendFrame(Frame.createTextFrame(JsonEncoder.encode(parameters)));
            LobbyWebSocketServer.lobbyWebSocketServer.writeLog("sendChatMessage B");
        }
        catch (Exception var5) {
            LobbyWebSocketServer.lobbyWebSocketServer.writeLog(var5);
        }
    }

    public void sendPlayersDisconnectedMessage(List<String> playerUIDs) {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("action", "playerDisconnected");
            parameters.put("playerUIDs", playerUIDs);
            String message = JsonEncoder.encode(parameters);
            Frame frame = Frame.createTextFrame(message);
            this.sendFrame(frame);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getPlayerInfo() {
        if (this.player == null) {
            return "player = null";
        }
        String output = "playerUID = " + this.player.playerUID + "\r\n";
        output = this.player.table == null ? output + "table = null\r\n" : output + "tableUID = " + this.player.table.tableUID + "\r\n";
        if (this.player.room == null) {
            output = output + "room = null\r\n";
            return output;
        }
        output = output + "roomID = " + this.player.room.roomID + "\r\n";
        if (this.player.room.game == null) {
            output = output + "player.room.game = null\r\n";
            return output;
        }
        output = output + "gameID = " + this.player.room.game.gameID + "\r\n";
        if (this.player.room.game.site == null) {
            output = output + "player.room.game.site = null\r\n";
            return output;
        }
        output = output + "siteID = " + this.player.room.game.site.siteID + "\r\n";
        return output;
    }
}

