/*
 * Decompiled with CFR 0.152.
 */
package com.novelgames.lobbywebsocketserver;

import com.novelgames.lobbywebsocketserver.JsonEncoder;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;

public class Config {
    public static final int DUPLICATENAMETREATMENT_SHOWALL = 1;
    public static final int DUPLICATENAMETREATMENT_DISCONNECTOLD = 2;
    public static final int DUPLICATENAMETREATMENT_DISCONNECTNEW = 3;
    public String host;
    public int port;
    public int duplicateNameTreatment;
    public String hashKey;
    public int extraKeyLength;
    public List<String> recordResultsCommandArguments;
    public int checkSendPingInterval;
    public int noReceiveSendPingTime;
    public int maxWaitPongTime;

    public Config() throws Exception {
        FileInputStream configFileInputStream = new FileInputStream(System.getProperty("config"));
        Properties properties = new Properties();
        properties.load(configFileInputStream);
        this.host = properties.getProperty("host");
        this.port = Integer.parseInt(properties.getProperty("port"));
        this.parseDuplicateNameTreatment(properties);
        this.parseHashKeyParameters(properties);
        this.parseRecordResultsCommandArguments(properties);
        this.parsePingParameters(properties);
    }

    private void parseDuplicateNameTreatment(Properties properties) throws Exception {
        String value = properties.getProperty("duplicateNameTreatment");
        this.duplicateNameTreatment = "disconnectOld".equals(value) ? 2 : ("disconnectNew".equals(value) ? 3 : 1);
    }

    private void parseHashKeyParameters(Properties properties) throws Exception {
        this.hashKey = properties.getProperty("hashKey");
        if (this.hashKey == null) {
            this.hashKey = "";
        }
        this.extraKeyLength = Integer.parseInt(properties.getProperty("extraKeyLength"));
    }

    private void parseRecordResultsCommandArguments(Properties properties) throws Exception {
        this.recordResultsCommandArguments = (List)JsonEncoder.decode(properties.getProperty("recordResultsCommandArguments"));
    }

    private void parsePingParameters(Properties properties) throws Exception {
        this.checkSendPingInterval = Integer.parseInt(properties.getProperty("checkSendPingInterval"));
        this.noReceiveSendPingTime = Integer.parseInt(properties.getProperty("noReceiveSendPingTime"));
        this.maxWaitPongTime = Integer.parseInt(properties.getProperty("maxWaitPongTime"));
    }
}

