/*
 * Decompiled with CFR 0.152.
 */
package com.novelgames.lobbywebsocketserver;

import com.novelgames.lobbywebsocketserver.Connection;
import com.novelgames.lobbywebsocketserver.LobbyWebSocketServer;
import com.novelgames.lobbywebsocketserver.Room;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConnectionsManager
extends Thread {
    public LobbyWebSocketServer lobbyWebSocketServer;
    private List<SocketChannel> newSocketChannels = null;
    private List<Connection> connections = null;
    private Selector selector = null;

    public ConnectionsManager(LobbyWebSocketServer lobbyWebSocketServer) throws Exception {
        this.lobbyWebSocketServer = lobbyWebSocketServer;
        this.newSocketChannels = Collections.synchronizedList(new ArrayList());
        this.connections = new ArrayList<Connection>();
        this.selector = Selector.open();
    }

    public void addSocketChannel(SocketChannel socketChannel) throws Exception {
        socketChannel.configureBlocking(false);
        this.newSocketChannels.add(socketChannel);
        this.selector.wakeup();
    }

    @Override
    public void run() {
        int checkSendPingInterval = this.lobbyWebSocketServer.config.checkSendPingInterval;
        while (true) {
            try {
                while (true) {
                    this.selector.select(checkSendPingInterval);
                    this.processNewSocketChannels();
                    this.processInputs();
                    this.sendPingsIfNeeded();
                    this.removeShouldBeRemovedPlayers();
                }
            }
            catch (Exception e) {
                this.lobbyWebSocketServer.writeLog(e);
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNewSocketChannels() {
        List<SocketChannel> list = this.newSocketChannels;
        synchronized (list) {
            for (SocketChannel socketChannel : this.newSocketChannels) {
                this.lobbyWebSocketServer.writeLog("processNewSocketChannels C");
                try {
                    Connection connection = new Connection(this, socketChannel);
                    socketChannel.register(this.selector, 1, connection);
                    this.connections.add(connection);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.lobbyWebSocketServer.writeLog("processNewSocketChannels D");
            }
            this.newSocketChannels.clear();
        }
    }

    private void processInputs() {
        Set<SelectionKey> set = null;
        set = this.selector.selectedKeys();
        if (set.size() == 0) {
            return;
        }
        this.lobbyWebSocketServer.writeLog("processInputs B");
        for (SelectionKey selectionKey : set) {
            this.lobbyWebSocketServer.writeLog("processInputs C");
            try {
                Connection connection = (Connection)selectionKey.attachment();
                connection.processInput();
            }
            catch (Exception e) {
                this.lobbyWebSocketServer.writeLog(e);
            }
            this.lobbyWebSocketServer.writeLog("processInputs D");
        }
        set.clear();
        this.lobbyWebSocketServer.writeLog("processInputs Z");
    }

    private void sendPingsIfNeeded() {
        for (Connection connection : this.connections) {
            if (connection.getSentPingButNoPongReceived()) {
                connection.shouldBeRemoved = true;
                continue;
            }
            connection.sendPingIfNeeded();
        }
    }

    private void removeShouldBeRemovedPlayers() {
        HashSet<Room> roomsWithRemovedPlayers = null;
        int i = this.connections.size() - 1;
        while (i >= 0) {
            Connection connection = this.connections.get(i);
            if (connection.shouldBeRemoved) {
                this.lobbyWebSocketServer.writeLog("removeShouldBeRemovedPlayers C");
                if (connection.player != null) {
                    connection.player.connection = null;
                }
                if (connection.player != null && connection.player.room != null) {
                    if (roomsWithRemovedPlayers == null) {
                        roomsWithRemovedPlayers = new HashSet<Room>();
                    }
                    roomsWithRemovedPlayers.add(connection.player.room);
                }
                connection.disconnect();
                this.connections.remove(connection);
                this.lobbyWebSocketServer.removePlayer(connection.player);
                this.lobbyWebSocketServer.writeLog("removeShouldBeRemovedPlayers D");
            }
            --i;
        }
        if (roomsWithRemovedPlayers == null || roomsWithRemovedPlayers.size() == 0) {
            return;
        }
        this.lobbyWebSocketServer.writeLog("removeShouldBeRemovedPlayers F");
        for (Room room : roomsWithRemovedPlayers) {
            this.lobbyWebSocketServer.writeLog("removeShouldBeRemovedPlayers G");
            room.sendPlayersDisconnectedMessages();
            this.lobbyWebSocketServer.writeLog("removeShouldBeRemovedPlayers H");
        }
        this.lobbyWebSocketServer.writeLog("removeShouldBeRemovedPlayers Z");
    }
}

