/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonEncoder {
    public static String encode(Object theObject) throws Exception {
        if (theObject instanceof Map) {
            return JsonEncoder.encodeHashtable((Map)theObject);
        }
        if (theObject instanceof List) {
            return JsonEncoder.encodeArray((List)theObject);
        }
        if (theObject instanceof String) {
            return JsonEncoder.encodeString((String)theObject);
        }
        if (theObject instanceof Byte) {
            return JsonEncoder.encodeByte((Byte)theObject);
        }
        if (theObject instanceof Integer) {
            return JsonEncoder.encodeInteger((Integer)theObject);
        }
        if (theObject instanceof Float) {
            return JsonEncoder.encodeFloat(((Float)theObject).floatValue());
        }
        if (theObject instanceof Boolean) {
            return JsonEncoder.encodeBoolean((Boolean)theObject);
        }
        if (theObject == null) {
            return JsonEncoder.encodeNull();
        }
        throw new Exception();
    }

    public static Object decode(String jsonString) throws Exception {
        StringBuffer jsonStringBuffer = new StringBuffer(jsonString);
        Object result = JsonEncoder.decodeFromStringBuffer(jsonStringBuffer);
        JsonEncoder.skipSpaces(jsonStringBuffer);
        if (jsonStringBuffer.length() > 0) {
            throw new Exception();
        }
        return result;
    }

    private static String encodeHashtable(Map<String, Object> hashtable) throws Exception {
        StringBuffer result = new StringBuffer();
        result.append("{");
        Set<String> keys = hashtable.keySet();
        for (String key : keys) {
            if (result.length() != 1) {
                result.append(",");
            }
            result.append(JsonEncoder.encodeString(key));
            result.append(":");
            result.append(JsonEncoder.encode(hashtable.get(key)));
        }
        result.append("}");
        return result.toString();
    }

    private static String encodeArray(List<Object> array) throws Exception {
        StringBuffer result = new StringBuffer();
        result.append("[");
        for (int i = 0; i < array.size(); ++i) {
            if (i != 0) {
                result.append(",");
            }
            result.append(JsonEncoder.encode(array.get(i)));
        }
        result.append("]");
        return result.toString();
    }

    private static String encodeString(String string) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        block9: for (int i = 0; i < string.length(); ++i) {
            char theChar = string.charAt(i);
            switch (theChar) {
                case '\b': {
                    result.append("\\b");
                    continue block9;
                }
                case '\t': {
                    result.append("\\t");
                    continue block9;
                }
                case '\n': {
                    result.append("\\n");
                    continue block9;
                }
                case '\f': {
                    result.append("\\f");
                    continue block9;
                }
                case '\r': {
                    result.append("\\r");
                    continue block9;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block9;
                }
                default: {
                    if (theChar >= ' ' && theChar != '\u007f') {
                        result.append(theChar);
                        continue block9;
                    }
                    result.append("\\u");
                    String hex = Integer.toHexString(theChar);
                    for (int j = hex.length(); j < 4; ++j) {
                        result.append('0');
                    }
                    result.append(hex);
                }
            }
        }
        result.append("\"");
        return result.toString();
    }

    private static String encodeByte(byte value) {
        return "" + value;
    }

    private static String encodeInteger(int value) {
        return "" + value;
    }

    private static String encodeFloat(float value) {
        return "" + value;
    }

    private static String encodeBoolean(boolean value) {
        return value ? "true" : "false";
    }

    private static String encodeNull() {
        return "null";
    }

    private static Object decodeFromStringBuffer(StringBuffer jsonString) throws Exception {
        int i;
        char firstChar = '\u0000';
        for (i = 0; i < jsonString.length() && ((firstChar = jsonString.charAt(i)) == ' ' || firstChar == '\t' || firstChar == '\r' || firstChar == '\n'); ++i) {
        }
        if (i >= jsonString.length()) {
            return null;
        }
        jsonString.delete(0, i);
        switch (firstChar) {
            case '\"': {
                return JsonEncoder.decodeString(jsonString);
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return JsonEncoder.decodeNumber(jsonString);
            }
            case '[': {
                return JsonEncoder.decodeArray(jsonString);
            }
            case 'f': {
                return JsonEncoder.decodeFalse(jsonString);
            }
            case 'n': {
                return JsonEncoder.decodeNull(jsonString);
            }
            case 't': {
                return JsonEncoder.decodeTrue(jsonString);
            }
            case '{': {
                return JsonEncoder.decodeObject(jsonString);
            }
        }
        return null;
    }

    private static Map<String, Object> decodeObject(StringBuffer jsonString) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        char theChar = jsonString.charAt(0);
        jsonString.deleteCharAt(0);
        if (theChar != '{') {
            throw new Exception();
        }
        while (jsonString.length() > 0) {
            String key;
            JsonEncoder.skipSpaces(jsonString);
            theChar = jsonString.charAt(0);
            if (theChar == '}') {
                jsonString.deleteCharAt(0);
                return result;
            }
            theChar = jsonString.charAt(0);
            if (theChar == '\"') {
                key = JsonEncoder.decodeString(jsonString);
            } else {
                int i;
                for (i = 0; i < jsonString.length() && !Character.isWhitespace(theChar = jsonString.charAt(i)) && theChar != ':'; ++i) {
                }
                if (i == 0) {
                    throw new Exception();
                }
                key = jsonString.substring(0, i);
                jsonString.delete(0, i);
            }
            JsonEncoder.skipSpaces(jsonString);
            theChar = jsonString.charAt(0);
            if (theChar != ':') {
                throw new Exception();
            }
            jsonString.deleteCharAt(0);
            JsonEncoder.skipSpaces(jsonString);
            result.put(key, JsonEncoder.decodeFromStringBuffer(jsonString));
            JsonEncoder.skipSpaces(jsonString);
            theChar = jsonString.charAt(0);
            if (theChar == ',') {
                jsonString.deleteCharAt(0);
                continue;
            }
            if (theChar == '}') continue;
            throw new Exception();
        }
        throw new Exception();
    }

    private static List<Object> decodeArray(StringBuffer jsonString) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        char theChar = jsonString.charAt(0);
        jsonString.deleteCharAt(0);
        if (theChar != '[') {
            throw new Exception();
        }
        while (jsonString.length() > 0) {
            JsonEncoder.skipSpaces(jsonString);
            theChar = jsonString.charAt(0);
            if (theChar == ']') {
                jsonString.deleteCharAt(0);
                return result;
            }
            result.add(JsonEncoder.decodeFromStringBuffer(jsonString));
            JsonEncoder.skipSpaces(jsonString);
            theChar = jsonString.charAt(0);
            if (theChar == ',') {
                jsonString.deleteCharAt(0);
                continue;
            }
            if (theChar == ']') continue;
            throw new Exception();
        }
        throw new Exception();
    }

    private static String decodeString(StringBuffer jsonString) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        char theChar = jsonString.charAt(0);
        jsonString.deleteCharAt(0);
        if (theChar != '\"') {
            throw new Exception();
        }
        block15: while (jsonString.length() > 0) {
            theChar = jsonString.charAt(0);
            jsonString.deleteCharAt(0);
            switch (theChar) {
                case '\"': {
                    return stringBuffer.toString();
                }
                case '\\': {
                    if (jsonString.length() == 0) {
                        throw new Exception();
                    }
                    theChar = jsonString.charAt(0);
                    jsonString.deleteCharAt(0);
                    switch (theChar) {
                        case '\"': {
                            stringBuffer.append('\"');
                            continue block15;
                        }
                        case '/': {
                            stringBuffer.append('/');
                            continue block15;
                        }
                        case '\\': {
                            stringBuffer.append('\\');
                            continue block15;
                        }
                        case 'b': {
                            stringBuffer.append('\b');
                            continue block15;
                        }
                        case 'f': {
                            stringBuffer.append('\f');
                            continue block15;
                        }
                        case 'n': {
                            stringBuffer.append('\n');
                            continue block15;
                        }
                        case 'r': {
                            stringBuffer.append('\r');
                            continue block15;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            continue block15;
                        }
                        case 'u': {
                            if (jsonString.length() < 4) {
                                throw new Exception();
                            }
                            String hex = jsonString.substring(0, 4);
                            jsonString.delete(0, 4);
                            stringBuffer.append((char)Integer.valueOf(hex, 16).shortValue());
                            continue block15;
                        }
                    }
                    throw new Exception();
                }
            }
            stringBuffer.append(theChar);
        }
        throw new Exception();
    }

    private static boolean decodeTrue(StringBuffer jsonString) throws Exception {
        if (jsonString.length() >= 4 && "true".equals(jsonString.substring(0, 4))) {
            jsonString.delete(0, 4);
            return true;
        }
        throw new Exception();
    }

    private static Boolean decodeFalse(StringBuffer jsonString) throws Exception {
        if (jsonString.length() >= 5 && "false".equals(jsonString.substring(0, 5))) {
            jsonString.delete(0, 5);
            return false;
        }
        throw new Exception();
    }

    private static Object decodeNull(StringBuffer jsonString) throws Exception {
        if (jsonString.length() >= 4 && "null".equals(jsonString.substring(0, 4))) {
            jsonString.delete(0, 4);
            return null;
        }
        throw new Exception();
    }

    private static Object decodeNumber(StringBuffer jsonString) throws Exception {
        Pattern pattern = Pattern.compile("-?(0|[1-9]\\d*)(\\.\\d+)?([eE][+-]?\\d+)?");
        Matcher matcher = pattern.matcher(jsonString);
        if (matcher.find() && matcher.start() == 0) {
            int end = matcher.end();
            String numberString = jsonString.substring(0, end);
            jsonString.delete(0, end);
            return Float.valueOf(numberString.indexOf(46) != -1 ? new Float(numberString).floatValue() : (float)new Integer(numberString).intValue());
        }
        throw new Exception();
    }

    private static void skipSpaces(StringBuffer jsonString) {
        while (jsonString.length() > 0) {
            char theChar = jsonString.charAt(0);
            if (!Character.isWhitespace(theChar)) {
                return;
            }
            jsonString.deleteCharAt(0);
        }
    }
}

